unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs,
  UFigury;


type
  TForm1 = class(TForm)
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormPaint(Sender: TObject);
  private

  public
	pro : Figura;		// uchwyt na prostokt
	kol : Figura;		// uchwyt na koo
	tro : Figura;		// uchwyt na trjkt

    procedure Spr();
  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   if Assigned(pro) then
   begin
		FreeAndNil(pro);
   end;

   if Assigned(kol) then
   begin
		FreeAndNil(kol);
   end;

   if Assigned(tro) then
   begin
		FreeAndNil(tro);
   end;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
	spr();
end;

procedure TForm1.Spr();
var
	x1  : Integer;
	y1  : Integer;
	x2  : Integer;
	y2  : Integer;

begin
   if not Assigned(pro) then
   begin
		x1 := 100;
   	y1 := 100;
	   x2 := 150;
	   y2 := 150;

		// pro := Prostokat.Create(Form1.Canvas, x1, y1, x2, y2);
		pro := Prostokat.Create(Form1.Canvas, Rect(x1, y1, x2, y2));
   end;

   if not Assigned(kol) then
   begin
		x1 := 200;
   	y1 := 200;
	   x2 := 250;
	   y2 := 250;

		kol := Kolo.Create(Form1.Canvas, Rect(x1, y1, x2, y2));
   end;

   if not Assigned(tro) then
   begin
		x1 := 300;
   	y1 := 300;
	   x2 := 350;
	   y2 := 350;

		tro := Trojkat.Create(Form1.Canvas, Rect(x1, y1, x2, y2));
   end;

   pro.Show();
   kol.Show();
   tro.Show();   
end;

end.



